<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly ?>
<div class="col-12 col-lg-3">
  <div class="kanews-section widget_accordion_menu">
  <?php echo kanews_widget_title(esc_html__( 'Kategoriler', 'kanews' ), 'h2'); ?>
    <?php 
      $taxonomies = get_terms( array(
        'taxonomy' => 'ilan-kategori',
        'hide_empty' => false,
        'parent' => 0 
      ) );
      if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
      $output = '<div><ul class="widget-accordion-menu">';
      foreach( $taxonomies as $category ) {
        $children = get_terms( array(
          'parent' => $category->term_id,
          'taxonomy' => 'ilan-kategori',
          'hide_empty' => false,
        ) );
        $output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
        if(!is_wp_error($children)) {
          $output .= '<ul class="sub-menu">';
          $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'.esc_html__( 'Hepsi', 'kanews' ).'</a></li>';
          foreach($children as $child) {
            $output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori-ilan')).'">'. $child->name .' ('.$child->count.')</a>';
          }
          $output .= '</ul>';
        }
        $output .= '</li>';
      }
      $output.='</ul></div>';
      echo $output;
      endif;
    ?>
  </div>
  <div class="kanews-section" style="overflow: unset">
    <?php echo kanews_widget_title(esc_html__( 'İlan Bul', 'kanews' ), 'h2'); ?>
    <div class="col-12">
      <div class="row g-10 p-1 pt-0">
      <a href="<?php echo esc_url( get_post_type_archive_link('ilan') ); ?>" class="col kanews-label text-center"><?php esc_html_e( 'Tüm İlanlar', 'kanews' ); ?></a>
      <?php if( kanews_get_option('account-page') ) : ?>
        <a href="<?php echo esc_url( get_page_link( kanews_get_option('account-page') ) ); ?>" class="col kanews-label text-center"><?php esc_html_e( 'İlan Ekle', 'kanews' ); ?></a>
      <?php endif; ?>
      </div>

    </div>
    <form class="px-1 py-1 pt-0 kanews-form-filter" action="<?php echo get_post_type_archive_link('ilan'); ?>">
      <div class="row no-gutters">
        <div class="col-12">
          <div class="kanews-form2 bgw position-relative">
            <input type="text" 
                   id="ilan-il-search" 
                   class="mb-0" 
                   placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                   autocomplete="off" />
            <button type="button" class="ilan-clear-btn" id="ilan-il-clear" style="display: none;">
              <i class="icon-close"></i>
            </button>
            <select id="ilan-il" style="display: none;">
              <option value=""><?php esc_html_e( 'İl Seç', 'kanews' ); ?></option>
            </select>
            <input type="hidden" name="il" id="ilan-il-hidden" value="" />
            <div id="ilan-il-dropdown" class="ilan-dropdown" style="display: none;"></div>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 bgw position-relative">
            <input type="text" 
                   id="ilan-ilce-search" 
                   class="mb-0" 
                   placeholder="<?php esc_html_e( 'Ara', 'kanews' ); ?>" 
                   autocomplete="off"
                   disabled />
            <button type="button" class="ilan-clear-btn" id="ilan-ilce-clear" style="display: none;">
              <i class="icon-close"></i>
            </button>
            <select id="ilan-ilce" style="display: none;">
              <option value=""><?php esc_html_e( 'İlçe Seç', 'kanews' ); ?></option>
            </select>
            <input type="hidden" name="ilce" id="ilan-ilce-hidden" value="" />
            <div id="ilan-ilce-dropdown" class="ilan-dropdown" style="display: none;"></div>
          </div>
        </div>
      </div>
      <?php 
        // İlan Kategori seçimi
        $kategoriler = get_terms( array(
            'taxonomy' => 'ilan-kategori',
            'hide_empty' => false,
            'parent' => 0
        ) );
        if ( !empty($kategoriler) && !is_wp_error($kategoriler) ) :
          // URL parametresinden veya mevcut taxonomy sayfasından kategori ID'sini al
          $selected_kategori = '';
          if (isset($_GET['kategori']) && !empty($_GET['kategori'])) {
            $selected_kategori = intval($_GET['kategori']);
          } elseif (is_tax('ilan-kategori')) {
            // Eğer ilan-kategori taxonomy sayfasındaysak, mevcut term'i seç
            $current_term = get_queried_object();
            if ($current_term && isset($current_term->term_id)) {
              // Eğer alt kategori ise, parent'ını bul
              if ($current_term->parent > 0) {
                // Alt kategori ise parent'ını seç
                $selected_kategori = $current_term->parent;
              } else {
                // Ana kategori ise direkt seç
                $selected_kategori = $current_term->term_id;
              }
            }
          }
          
          $output = '<div class="empty" style="display: block;height: 10px"></div>';
          $output .= '<div class="kanews-form2 bgw">';
          $output .= '<select name="kategori" class="mb-0">';
          $output .= '<option value="">'.esc_html__( 'Kategori Seç', 'kanews' ).'</option>';
          foreach( $kategoriler as $kategori ) {
            $selected = ($selected_kategori == $kategori->term_id) ? ' selected' : '';
            $output .= '<option value="'.esc_attr( $kategori->term_id ).'"'.$selected.'>'.esc_html( $kategori->name ).'</option>';
          }
          $output .= '</select>';
          $output .= '</div>';
          echo $output;
        endif;
      ?>
      <?php 
        // İlan Etiket seçimi
        $taxonomies = get_terms( array(
            'taxonomy' => 'ilan-etiket',
            'hide_empty' => false
        ) );
        if ( !empty($taxonomies) ) :
          $output = '<div class="empty" style="display: block;height: 10px"></div><div class="row kanews-scroll" style="max-height: 200px">';
          foreach( $taxonomies as $category ) {
            $checked = (isset($_GET['labels']) && in_array($category->term_id, (array)$_GET['labels'])) ? ' checked' : '';
            $output .= '<div class="col-12 d-flex"><div class="kanews-form"><input type="checkbox" name="labels[]" value="'.esc_attr( $category->term_id ).'" id="ilan-etiket-'.$category->slug.'"'.$checked.' />
            </div><label for="ilan-etiket-'.$category->slug.'">'.esc_html( $category->name ).'</label></div>';
          }
          $output.='</div>';
          echo $output;
        endif;
      ?>
      <div class="kanews-form2 bgw">
        <input class="mb-0" type="text" name="search" placeholder="<?php esc_html_e('Kelime Ara', 'kanews'); ?>" value="<?php echo isset($_GET['search']) ? esc_attr($_GET['search']) : ''; ?>" />
      </div>
      <div class="kanews-form2 bgw">
        <input class="mb-0" type="number" name="p" min="1" placeholder="<?php esc_html_e('İlan no ile ara', 'kanews'); ?>" value="<?php echo isset($_GET['p']) ? esc_attr($_GET['p']) : ''; ?>" />
      </div>
      <button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0"><?php esc_html_e( 'Filtrele', 'kanews' ); ?></button>
    </form>
    
    <script>
      (function(){
        var form = document.querySelector('.kanews-form-filter');
        if(!form) return;
        form.addEventListener('submit', function(){
          var pid = form.querySelector('input[name="p"]');
          if(pid && pid.value){
            form.action = '<?php echo esc_url( home_url('/') ); ?>';
          }
        });
      })();
    </script>
  </div>
</div>