<div class="kanews-section-flat kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Döviz Fiyatları', 'kanews' ), 'h3'); ?>
                <?php 
                $response2 = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/currencies/currencies.json");
                $data2 = json_decode($response2, true); 
                if(isset($data2['data']) ) {
                  $last_update_date  = $data2['lastUpdate']['formatted'];
                  $data2 = $data2['data'];
                  $data2['Update_Date'] = $last_update_date;
                } 
                ?>

                <div class="kanews-inline-card kanews-scroll" style="max-height: 459px; padding: 2px !important;">
                    <?php
                    if(!empty($data2) && is_array($data2) && isset($data2['USD'])) {
                      $currency_count = 0;
                      foreach(array_slice($data2, 1) as $key => $currency) {
                        $valid_keys = array('USD', 'EUR', 'JPY', 'GBP', 'CHF', 'CNY', 'RUB', 'AUD');

                        if (in_array($key, $valid_keys)) {
                          if( isset($currency['Type']) && $currency['Type'] != 'Gold' ) {
                            $currency_count++;
                            $change_percent = isset($currency['Change']) ? floatval($currency['Change']) : 0;
                            $class = $change_percent < 0 ? 'color-danger' : 'color-success';
                            $icon = $change_percent < 0 
                                ? '<svg class="icon-trending color-danger icon-180deg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
                                : '<svg class="icon-trending color-success" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                            
                            $search  = array( 'CSK' );
                            $replace = array( 'CZK' );
                            $key = str_replace($search, $replace, $key);
                            $country_code = substr($key, 0, -1);
                            $img = kanews_get_local_image(
                                "https://s3-symbol-logo.tradingview.com/country/{$country_code}.svg",
                                ['alt' => $key, 'width' => 18, 'height' => 18],
                                '1e1'
                            );
                            $value = isset($currency['Selling']) ? (float)$currency['Selling'] : 0;
                            $page_link = kanews_get_page_link('parite', strtolower($key), 'doviz');
                            ?>
                            <div class="kanews-inline-card-item no-gutters" onclick="window.location='<?php echo esc_js($page_link); ?>';" style="cursor: pointer;">
                                <div class="kanews-inline-card-summary col d-flex justify-content-between align-items-center">
                                    <div class="kanews-inline-card-title d-flex flex-column">
                                        <?php if ($img): ?>
                                        <div class="kanews-inline-card-icon col-auto">
                                            <span class="hbfdg12">
                                                <?php echo $img; ?>
                                            </span>
                                        </div>
                                        <?php endif; ?>
                                        <div class="name">
                                            <a href="<?php echo esc_url($page_link); ?>"><?php echo esc_html($key . '/TRY'); ?></a>
                                        </div>
                                        <div>
                                            <?php echo number_format($value, 2, ",", "."); ?> TL
                                        </div>
                                    </div>
                                    <div class="kanews-inline-card-content">
                                        <?php if ($change_percent != 0): ?>
                                            <div class="d-flex flex-column align-items-center <?php echo esc_attr($class); ?>">
                                                <div><?php echo $icon; ?></div>
                                                <div><?php echo esc_html($change_percent . '%'); ?></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                          }
                        }
                      }
                      
                      if ($currency_count == 0) {
                        echo '<div class="kanews-inline-card-item"><div class="kanews-inline-card-summary">'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</div></div>';
                      }
                    } else {
                      echo '<div class="kanews-inline-card-item"><div class="kanews-inline-card-summary">'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</div></div>';
                    }
                    ?>
                </div>
              </div>

<div class="kanews-section-flat kanews-section">
  <?php echo kanews_widget_title(esc_html__( 'Kripto Para Fiyatları', 'kanews' ), 'h3'); ?>
  <div class="kanews-inline-card kanews-scroll" style="max-height: 410px; padding: 2px !important;">
      <?php
      $indexes = [
        'try' => esc_html__( 'Türk Lirası', 'kanews' ),
        'usdt' => esc_html__( 'Amerikan Doları', 'kanews' ),
        'eur' => esc_html__( 'Euro', 'kanews' ),
        'btc' => esc_html__( 'Bitcoin', 'kanews' ),
        'eth' => esc_html__( 'Ethereum', 'kanews' ),
      ];
      $index = isset($_GET['index']) ? esc_html($_GET['index']) : kanews_get_option('crypto-page-index', 'try');
      $data = json_decode(kanews_crypto_data($index)); 
      
      if(!empty($data)) {
        $coin_count = 0;
        foreach($data as $coin) {
          if($coin->market_cap_rank == 8) 
          break;
          $coin_count++;
          $change = $coin->price_change_percentage_24h;
          $change_percent = floatval($change);
          $class = $change_percent < 0 ? 'color-danger' : 'color-success';
          $icon = $change_percent < 0 
              ? '<svg class="icon-trending color-danger icon-180deg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
              : '<svg class="icon-trending color-success" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="32" width="32" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
          
          $page_link = kanews_get_page_link('coin', strtolower($coin->id), 'crypto');
          $img = kanews_get_local_image($coin->image, array('width' => 18, 'height' => 18, 'alt' => $coin->symbol));
          ?>
          <div class="kanews-inline-card-item" onclick="window.location='<?php echo esc_js($page_link); ?>';" style="cursor: pointer;">
              <div class="kanews-inline-card-summary col d-flex justify-content-between align-items-center">
                  <div class="kanews-inline-card-title d-flex flex-column">
                      <?php if ($img): ?>
                      <div class="kanews-inline-card-icon col-auto">
                          <span class="hbfdg12">
                              <?php echo $img; ?>
                          </span>
                      </div>
                      <?php endif; ?>
                      <div class="name">
                          <a href="<?php echo esc_url($page_link); ?>">
                              <div><?php echo esc_html(strtoupper($coin->symbol)); ?></div>
                              <div class="color-muted"><?php echo esc_html($coin->name); ?></div>
                          </a>
                      </div>
                      <div>
                          <?php echo currency_format_number($coin->current_price); ?> <?php echo esc_html(strtoupper($index)); ?>
                      </div>
                  </div>
                  <div class="kanews-inline-card-content">
                      <?php if ($change_percent != 0): ?>
                          <div class="d-flex flex-column align-items-center <?php echo esc_attr($class); ?>">
                              <div><?php echo $icon; ?></div>
                              <div><?php echo esc_html(round($change_percent, 2) . '%'); ?></div>
                          </div>
                      <?php endif; ?>
                  </div>
              </div>
          </div>
          <?php
        }
        
        if ($coin_count == 0) {
          echo '<div class="kanews-inline-card-item"><div class="kanews-inline-card-summary">'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</div></div>';
        }
      } else {
        echo '<div class="kanews-inline-card-item"><div class="kanews-inline-card-summary">'.esc_html__( 'Veri alınamadı!', 'kanews' ).'</div></div>';
      }
      
      ?>
  </div>
</div>  

