<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

if( get_post_type() == 'ilan' || get_post_type() == 'columist' || get_post_type() == 'firma' ) {
	get_template_part( 'template-parts/content/single', get_post_type() );
} else {
	get_header();
	?>
		<?php do_action('kanews_header_ad'); ?>
		<main id="main" class="site-main">
			<div class="container">
				<div class="row">
					<div class="site-main-wrapper">
						<div class="site-main-inner d-flex flex-wrap">
							
							<?php 
								while ( have_posts() ) : the_post();
									$GLOBALS['kan_do_not_duplicate'][ get_the_ID() ] = get_the_ID();
									if( !empty( get_post_meta( get_the_ID(), 'kanews_bik_id', true ) ) ) {
										get_template_part( 'template-parts/content/resmi-ilan');
									} else {
										get_template_part( 'template-parts/content/content', get_post_format());
									}
								endwhile;
							?>
							
						</div>
					</div>
					<div style="display:none" class="page-load-status">
						<div class="loader-ellips infinite-scroll-request">
							<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"> <path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/> <path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"> <animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/> </path> </svg>
						</div>
						<p class="infinite-scroll-last"><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'kanews'); ?></p>
						<p class="infinite-scroll-error"><?php _e('Tekrar deneyiniz.', 'kanews'); ?></p>
					</div>
				</div>
			</div>
		</main>

	<?php
	get_footer();
}
