<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_script('kanews-ilan-search');
get_header();
$term = get_queried_object();
$term_title = $term ? $term->name : get_the_archive_title();
$term_description = $term ? $term->description : '';
kanews_page_header_cpt($term_title, $term_description, 'ilan');
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php get_sidebar('ilan'); ?>
        <div class="col-12 col-lg-9">
          <?php
            echo '<div class="kanews-section kanews-section-flat kanews-posts-style-2 column_x_gutter kanews-section-gutter">';
              echo kanews_widget_title($term_title, 'h2');
              if ( have_posts() ) : 
                echo '<div class="row equal-height" kanews-data-load-more>';
                  while ( have_posts() ) : the_post(); 
                    get_template_part('template-parts/archives/article', 'ilan');
                  endwhile;
                echo '</div>';
                kanews_pagination();
              else:
                get_template_part('template-parts/archives/article', 'none');
              endif;
            echo '</div>';
          ?>
        </div>
        
      </div>
		</div>
	</main>

<?php
get_footer();
?>