<?php
/**
 * The template for displaying archive pages
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Kanews
 * @since 1.0.0
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header();

// Get term info
$term = get_queried_object();
$term_title = $term ? $term->name : get_the_archive_title();
$term_description = $term ? $term->description : '';

kanews_page_header_cpt($term_title, $term_description, 'firma');
?>
<?php do_action('kanews_header_ad'); ?>
<main id="main" class="site-main">
  <div class="container">
    <div class="row">
    <?php get_sidebar('firma'); ?>
      <div class="col-12 col-lg-9">
        <?php 

echo '<div class="kanews-section kanews-section-flat">';
echo kanews_widget_title(get_the_archive_title(), 'h2');
$style = kanews_get_option('firma-style') ? kanews_get_option('firma-style') : 1; 


switch($style) {
  case '1':
    $style = 'comp';
    break;
  case '2':
    $style = 'comp-2';
    break;
  case '3':
    $style = 'comp-3';
    break;
}

if ( have_posts() ) : 
  echo '<div class="row" kanews-data-load-more>';
    while ( have_posts() ) : the_post(); 
      get_template_part('template-parts/archives/article', $style);
    endwhile;
  echo '</div>';
  kanews_pagination();
else:
  get_template_part('template-parts/archives/article', 'none');
endif;
echo '</div>';
?>
      </div>
      
        
    </div>
  </div>
</main>
<?php
get_footer();