<?php 
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

function generate_custom_title($title) {
  return esc_html__( 'Yazarlarımız', 'kanews').' - ' .get_bloginfo("name");
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );
get_header(); ?>
<?php kanews_page_header(get_the_ID(), esc_html__( 'Yazarlarımız', 'kanews' ), '', '', false); ?>
<?php do_action('kanews_header_ad'); ?>

  <main id="main" class="site-main mb-3">
    <div class="container">
      <div class="row">

        <?php 
        $lists = kanews_get_option('author-lists');

        if($lists): ?>

          <?php foreach ( $lists as $list ) {
            echo $list['title'] != '' ? '<h2 class="col-12 mt-1 mobile-padding">'.kanews_widget_title($list['title']).'</h2>' : '';
            if($list['authors']) {
              foreach ( $list['authors'] as $author ) {
                $user_data = get_userdata($author);

                if(!is_object($user_data))
                continue;
                ?>
                <div class="col-6 col-md-3 mobile-padding">
                  <div class="kanews-profile-card">
                    <div class="kanews-profile-card-header">
                      <?php echo kanews_user_avatar(get_the_author_meta('ID', $user_data->ID),120); ?>
                    </div>
                    <div class="kanews-profile-card-body">
                      <h2 class="truncate truncate-1 color-primary"><?php if(get_the_author_meta('first_name', $user_data->ID) && get_the_author_meta('last_name', $user_data->ID)): ?>
                        <?php echo esc_html(get_the_author_meta('first_name', $user_data->ID)); ?> <?php echo esc_html(get_the_author_meta('last_name', $user_data->ID)); ?>
                      <?php else: ?>
                        <?php echo esc_html(get_the_author_meta('display_name', $user_data->ID)); ?>
                      <?php endif; ?></h2>
                    </div>
                    <div class="kanews-profile-card-footer">
                      <?php
                      $args = array(
                        'post_type' => array('post', 'columnist'),
                        'author' => $user_data->ID,
                        'posts_per_page' => 1,
                      );
                      $query = new WP_Query($args);
                      if($query->have_posts()):
                        while($query->have_posts()): $query->the_post();
                        global $post;
                        ?>
                        <h3 class="kanews-post-headline truncate truncate-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <div>
                          <?php echo kanews_post_date('post', 'span'); ?>
                        </div>
                        <?php
                        endwhile;
                        wp_reset_postdata();
                      endif;
                      ?>
                    </div>
                  </div>
                </div>
                <?php 
              }
            }
          } ?>

        <?php endif; ?>

          

  </main> 

<?php
get_footer();