<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_script('kanews-ilan-search');
get_header();
$q = get_queried_object();

// Dinamik title belirleme
$page_title = esc_html__( 'Firma Rehberi', 'kanews' );
$widget_title = esc_html__( 'Yeni Eklenen Firmalar', 'kanews' );

$title_parts = array();

// Kategori filtresi kontrolü
$kategori_name = '';
if (isset($_GET['comp_cat']) && !empty($_GET['comp_cat'])) {
    $kategori_id = intval($_GET['comp_cat']);
    $kategori_term = get_term($kategori_id, 'kategori');
    if ($kategori_term && !is_wp_error($kategori_term)) {
        $kategori_name = $kategori_term->name;
        $title_parts[] = $kategori_name;
    }
}

// İl/Ülke filtresi kontrolü
$il_name = '';
$ilce_name = '';
if (isset($_GET['il']) && !empty($_GET['il'])) {
    $il_param = sanitize_text_field($_GET['il']);
    if (is_numeric($il_param) && ($il_param > 0 && $il_param <= 81)) {
        $il_name = kanews_get_sehir($il_param);
    } else if (!is_numeric($il_param)) {
        $il_name = $il_param;
    }
    if (!empty($il_name)) {
        $ilce_param = isset($_GET['ilce']) ? sanitize_text_field($_GET['ilce']) : '';
        if (!empty($ilce_param)) {
            $ilce_name = $ilce_param;
            $title_parts[] = $il_name . ' - ' . $ilce_name;
        } else {
            $title_parts[] = $il_name;
        }
    }
}
// Ülke filtresi kontrolü
else if (isset($_GET['ulke']) && !empty($_GET['ulke'])) {
    $ulke_name = sanitize_text_field($_GET['ulke']);
    $sehir_param = isset($_GET['sehir']) ? sanitize_text_field($_GET['sehir']) : '';
    if (!empty($sehir_param)) {
        $title_parts[] = $ulke_name . ' - ' . $sehir_param;
    } else {
        $title_parts[] = $ulke_name;
    }
}

// Firma adı arama kontrolü
$comp_name = '';
if (isset($_GET['comp_name']) && !empty($_GET['comp_name'])) {
    $comp_name = sanitize_text_field($_GET['comp_name']);
}

// Title oluştur
if (!empty($comp_name) && !empty($title_parts)) {
    // Hem arama hem filtre var
    $page_title = sprintf(esc_html__('"%s" için %s Firma Sonuçları', 'kanews'), $comp_name, implode(' - ', $title_parts));
    $widget_title = sprintf(esc_html__('"%s" için %s Firma Sonuçları', 'kanews'), $comp_name, implode(' - ', $title_parts));
} else if (!empty($comp_name)) {
    // Sadece arama var
    $page_title = sprintf(esc_html__('"%s" için Firma Sonuçları', 'kanews'), $comp_name);
    $widget_title = sprintf(esc_html__('"%s" için Firma Sonuçları', 'kanews'), $comp_name);
} else if (!empty($title_parts)) {
    // Sadece filtre var
    $page_title = sprintf(esc_html__('%s Firmaları', 'kanews'), implode(' - ', $title_parts));
    $widget_title = sprintf(esc_html__('%s Firmaları', 'kanews'), implode(' - ', $title_parts));
}

kanews_page_header_cpt($page_title, esc_html__('Binlerce firmanın bilgilerine ulaşın, işletmenizi ücretsiz ekleyin.', 'kanews'), 'firma'); 
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php get_sidebar('firma'); ?>
        <div class="col-12 col-lg-9">
          <?php
  

            echo '<div class="kanews-section kanews-section-flat">';
              echo kanews_widget_title($widget_title, 'h2');
              $style = kanews_get_option('firma-style') ? kanews_get_option('firma-style') : 1; 

              switch($style) {
                case '1':
                  $style = 'comp';
                  break;
                case '2':
                  $style = 'comp-2';
                  break;
                case '3':
                  $style = 'comp-3';
                  break;
              }

              if ( have_posts() ) : 
                echo '<div class="row" kanews-data-load-more>';
                  while ( have_posts() ) : the_post(); 
                    get_template_part('template-parts/archives/article', $style);
                  endwhile;
                echo '</div>';
                kanews_pagination();
              else:
                get_template_part('template-parts/archives/article', 'none');
              endif;
            echo '</div>';
          ?>
        </div>
        
      </div>
		</div>
	</main>

<?php
get_footer();
