<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_script('kanews-ilan-search');
get_header();
$q = get_queried_object();

// Dinamik title belirleme
$page_title = esc_html__( 'İlanlar', 'kanews' );
$widget_title = esc_html__( 'Yeni İlanlar', 'kanews' );

$title_parts = array();

// Kategori filtresi kontrolü
$kategori_name = '';
if (isset($_GET['kategori']) && !empty($_GET['kategori'])) {
    $kategori_id = intval($_GET['kategori']);
    $kategori_term = get_term($kategori_id, 'ilan-kategori');
    if ($kategori_term && !is_wp_error($kategori_term)) {
        $kategori_name = $kategori_term->name;
        $title_parts[] = $kategori_name;
    }
}

// İl/Ülke filtresi kontrolü
$il_name = '';
$ilce_name = '';
if (isset($_GET['il']) && !empty($_GET['il'])) {
    $il_param = sanitize_text_field($_GET['il']);
    if (is_numeric($il_param) && ($il_param > 0 && $il_param <= 81)) {
        $il_name = kanews_get_sehir($il_param);
    } else if (!is_numeric($il_param)) {
        $il_name = $il_param;
    }
    if (!empty($il_name)) {
        $ilce_param = isset($_GET['ilce']) ? sanitize_text_field($_GET['ilce']) : '';
        if (!empty($ilce_param)) {
            $ilce_name = $ilce_param;
            $title_parts[] = $il_name . ' - ' . $ilce_name;
        } else {
            $title_parts[] = $il_name;
        }
    }
}
// Ülke filtresi kontrolü
else if (isset($_GET['ulke']) && !empty($_GET['ulke'])) {
    $ulke_name = sanitize_text_field($_GET['ulke']);
    $sehir_param = isset($_GET['sehir']) ? sanitize_text_field($_GET['sehir']) : '';
    if (!empty($sehir_param)) {
        $title_parts[] = $ulke_name . ' - ' . $sehir_param;
    } else {
        $title_parts[] = $ulke_name;
    }
}

// Arama yapılmışsa
$search_term = '';
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search_term = sanitize_text_field($_GET['search']);
}

// Title oluştur
if (!empty($search_term) && !empty($title_parts)) {
    // Hem arama hem filtre var
    $page_title = sprintf(esc_html__('"%s" için %s Arama Sonuçları', 'kanews'), $search_term, implode(' - ', $title_parts));
    $widget_title = sprintf(esc_html__('"%s" için %s Arama Sonuçları', 'kanews'), $search_term, implode(' - ', $title_parts));
} else if (!empty($search_term)) {
    // Sadece arama var
    $page_title = sprintf(esc_html__('"%s" için Arama Sonuçları', 'kanews'), $search_term);
    $widget_title = sprintf(esc_html__('"%s" için Arama Sonuçları', 'kanews'), $search_term);
} else if (!empty($title_parts)) {
    // Sadece filtre var
    $page_title = sprintf(esc_html__('%s İlanları', 'kanews'), implode(' - ', $title_parts));
    $widget_title = sprintf(esc_html__('%s İlanları', 'kanews'), implode(' - ', $title_parts));
}
// Taxonomy sayfası ise
else if (is_tax('ilan-ilce', 'ilan-il')) {
    $page_title = sprintf(esc_html__('%s İlanları', 'kanews'), $q->name);
    $widget_title = sprintf(esc_html__('%s İlanları', 'kanews'), $q->name);
}

kanews_page_header_cpt($page_title, esc_html__('İlginizi çeken ilanları keşfedin, ilanınızı ücretsiz ekleyin.', 'kanews'), 'ilan'); 
?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php get_sidebar('ilan'); ?>
        <div class="col-12 col-lg-9">
          <?php

            echo '<div class="kanews-section kanews-section-flat kanews-posts-style-2 column_x_gutter kanews-section-gutter">';
              echo kanews_widget_title($widget_title, 'h2');
              $out = '<div class="kanews-dropdown kanews-dropdown-ilan">'; 
                $out .= '<div data-toggle="kanews-ilan-sort" class="kanews-label cursor-pointer">'.esc_html__( 'Sıralama Ölçütü', 'kanews' ).' <i class="icon-arrow icon-180deg"></i></div>';
                $out .= '<div id="kanews-ilan-sort" class="kanews-dropdown-content">';
                  $out .= '<ul>';
                    $out .= '<li><a href="'.get_post_type_archive_link('ilan').'">'.esc_html__( 'Öne Çıkanlar', 'kanews' ).'</a></li>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'da', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Eski)', 'kanews' ).'</a></li>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'dd', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Yeni)', 'kanews' ).'</a></li>';
                  $out .= '</ul>';
                $out .= '</div>'; 
              $out .= '</div>'; 
              echo $out;
              global $wp_query;
              $args = array_merge( $wp_query->query_vars, array( 'post_type' => 'ilan' ) );
              
              // Tax query array'ini başlat
              if (!isset($args['tax_query'])) {
                  $args['tax_query'] = array();
              }
              $sehir_tax_query = null;

              // İl/Ülke filtresi (il veya ulke parametresi)
              $il_param = isset($_GET['il']) ? $_GET['il'] : (isset($_GET['ulke']) ? $_GET['ulke'] : '');
              if (!empty($il_param)) {
                  $il_value = sanitize_text_field($il_param);
                  $sehir_name = '';
                  
                  // Numeric ise (plaka numarası) - eski format
                  if (is_numeric($il_value) && ($il_value > 0 && $il_value <= 81)) {
                      $sehir_name = kanews_get_sehir($il_value);
                  } 
                  // String ise (şehir/ülke ismi) - yeni format
                  else if (!is_numeric($il_value)) {
                      $sehir_name = $il_value;
                  }
                  
                  // Şehir/ülke ismi varsa taxonomy sorgusu oluştur
                  if (!empty($sehir_name)) {
                      $sehir_tax_query = array(
                          'taxonomy' => 'ilan-il',
                          'field'    => 'name',
                          'terms'    => $sehir_name,
                      );
                      $args['tax_query'][] = $sehir_tax_query;
                  }
              }

              // İlçe/Şehir filtresi (ilce veya sehir parametresi)
              $ilce_param = isset($_GET['ilce']) ? $_GET['ilce'] : (isset($_GET['sehir']) ? $_GET['sehir'] : '');
              if (!empty($ilce_param)) {
                  $ilce_value = sanitize_text_field($ilce_param);
                  
                  $ilce_tax_query = array(
                      'taxonomy' => 'ilan-ilce',
                      'field'    => 'name',
                      'terms'    => $ilce_value,
                  );

                  $args['tax_query'][] = $ilce_tax_query;
              }
              
              // İlan Kategori filtresi
              if (isset($_GET['kategori']) && !empty($_GET['kategori'])) {
                  $kategori_id = intval($_GET['kategori']);
                  $kategori_tax_query = array(
                      'taxonomy' => 'ilan-kategori',
                      'field'    => 'term_id',
                      'terms'    => $kategori_id,
                  );
                  $args['tax_query'][] = $kategori_tax_query;
              }

              // Tax query relation ayarla (birden fazla taxonomy varsa)
              if (count($args['tax_query']) > 1) {
                  $args['tax_query']['relation'] = 'AND';
              }

              // İlan Etiket filtresi
              if (isset($_GET['labels']) && !empty($_GET['labels'])) {
                  $label_tax_query = array(
                      'taxonomy' => 'ilan-etiket',
                      'field'    => 'term_id',
                      'terms'    => $_GET['labels'],
                  );

                  $args['tax_query'][] = $label_tax_query;
              }


              if( isset($_GET['search']) && !empty( $_GET['search'] )  )
              $args = array_merge($args, array('s' => $_GET['search']) );
						
              if( class_exists('Simple_Review')  )
              $args = array_merge($args, array('orderby' => 'menu_order') );

              // print_r($args);

              query_posts( $args );
              if ( have_posts() ) : 
                echo '<div class="row equal-height" kanews-data-load-more>';
                  while ( have_posts() ) : the_post(); 
                    get_template_part('template-parts/archives/article', 'ilan', array('col'=> 'col-6 col-md-4'));
                  endwhile;
                echo '</div>';
                kanews_pagination();
              else:
                get_template_part('template-parts/archives/article', 'none');
              endif;
            echo '</div>';

            wp_reset_query();
          ?>
        </div>
        
      </div>
		</div>
	</main>

<?php
get_footer();
?>