<?php 
$paged1 = isset( $_GET['paged'] ) ? (int) $_GET['paged'] : 1;
$paged2 = isset( $_GET['paged2'] ) ? (int) $_GET['paged2'] : 1;
global $wp_query;
$args = array_merge( $wp_query->query_vars, array( 'cat' => get_queried_object_id(  )) );

$date_query = array(
  array(
    'year'  => date( 'Y' ),
    'month' => date( 'm' ),
    'day'   => date( 'd' ),
    'compare' => '=',
    'inclusive' => true,
  ),
);
$args = array_merge($args, array( 'date_query' => $date_query ));
query_posts( $args );
$found_posts = $wp_query->found_posts;

?>

<div class="kanews-widget-area kanews-widgets-top">
  <div class="col-12">
    <div class="single-layout-flat">
      <div class="kanews-section-box">
        <div class="kanews-article-header p-0 mb-1">
          <h2 class="kanews-article-title mb-0"><?php echo esc_html__( 'Resmi İlanlar', 'kanews' ); ?></h2>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="kanews-widget-area kanews-widgets-content">

  <div class="col-12 col-lg-8">
    <div class="row">
      
      <?php 
        $title = esc_html__('Bugün Yayınlanan İlanlar', 'kanews');
        kanews_recent_posts('cat-ilan', $title, 'h2'); 

        echo '<div class="col-12">';
        echo '<div class="kanews-section kanews-posts-style-3 column_x_gutter">';
          
          echo kanews_widget_title(esc_html__( 'Arşivlenen İlanlar', 'kanews' ));
          wp_reset_query(); 
          $paged = isset( $_GET['paged1'] ) ? (int) $_GET['paged1'] : 1;
					global $wp_query;
          $args = array(
            'posts_per_page' => $wp_query->query_vars['posts_per_page'],
            'paged' => $paged2,
            'cat' => get_queried_object_id(  ),
          );		
          if( isset($_GET['text']) && $_GET['text'] != ''  )
          $args['s'] =  $_GET['text'];

          if( isset($_GET['datefilter']) ) {
            
            $date_filter = explode('-', $_GET['datefilter']);
            echo '<div class="kanews-dropdown-search" style="    position: absolute;
            right: 1.5rem;
            top: 12px;">Tarih Aralığı : '.$date_filter[0] .' - '.$date_filter[1].'</div>';
            
            if( isset($date_filter[0]) && isset($date_filter[1]) ) {
              $date_query = array(
                array(
                  'after' => $date_filter[0]. '00:00:00',
                  'before' => $date_filter[1].' 23:59:59',
                  'inclusive' => true,
                )
                );
              $args['date_query'] = $date_query;
            }
          }else {
            $args['date_query'] = array(
              array(
                'before'      => current_time( 'Y-n-j' ),
                'inclusive' => true,
              ),
            );
          }
          $kanews_query = new WP_Query( $args );
          
          if ( have_posts() ) : 
            echo '<div class="row m-0 py-1 equal-height">';
            while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;
            get_template_part('template-parts/archives/article', '3x');
            endwhile; wp_reset_postdata(  );
            echo '</div>';
            ?>
            <div class="navigation pagination">
            <div class="nav-links">
              <?php 
              // print_r($kanews_query);
                echo paginate_links( array(
                  'format'  => '?paged2=%#%',
                  'current' => $paged2,
                  'total'   => $kanews_query->max_num_pages,
                  'show_all'     => false,
                  'type'         => 'plain',
                  'end_size'     => 2,
                  'mid_size'     => 1,
                  'prev_next'    => true,
                  'prev_text'    => '<i class="icon-arrow icon-90degg"></i>',
                  'next_text'    => '<i class="icon-arrow icon-90deg"></i>',
                  'add_args' => array( 'paged' => $paged1 ),

                  'add_fragment' => '',
                ) );
              ?>
            </div>
          </div>
            <?php 
          else:
            if( isset($_GET['datefilter']) && !empty($_GET['datefilter']) )
            echo '<p>Seçilen tarih aralığı için listelenebilecek bir ilan bulunamadı.</p>';
            else
            echo '<p>Henüz bir ilan yayınlanmadı..</p>';
          endif; 
        echo '</div></div>';
      ?>
    </div>
  </div>

  <div class="col-12 col-lg-4">

    <div class="kanews-section">
      <?php echo kanews_widget_title(esc_html__( 'İlan Filtrele', 'kanews' ), 'h4'); ?>
      <form class="p-1" action="<?php echo esc_url( get_category_link(get_queried_object_id(  )) ); ?>">
      
        <div class="kanews-form">
          <input autocomplete="off"  type="text" class="datefilter" name="datefilter" value="<?php echo isset($_GET['datefilter']) ? esc_attr($_GET['datefilter']) : ''; ?>" />
          <label><?php _e('Yayın Tarihi', 'kanews'); ?></label>
        </div>

        <div class="kanews-form">
          <input class="mb-0" type="text" name="text" value="<?php echo isset($_GET['text']) ? esc_attr($_GET['text'] ): ''; ?>" autocomplete="off"/>
          <label><?php _e('Kelime Ara', 'kanews'); ?></label>
        </div>

        <button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0"><?php esc_html_e( 'İlan Ara', 'kanews' ); ?></button>

      </form>
    </div>

    <div class="kanews-section widget_accordion_menu">
      <?php echo kanews_widget_title(esc_html__( 'Kategoriler', 'kanews' ), 'h4'); ?>
      <?php 
        $taxonomies = get_terms( array(
          'taxonomy' => 'category',
          'hide_empty' => true,
          'parent' => 0 
        ) );
        if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
        $output = '<div><ul class="widget-accordion-menu">';
        foreach( $taxonomies as $category ) {
          $children = get_terms( array(
            'parent' => $category->term_id,
            'taxonomy' => 'category',
            'hide_empty' => false,
          ) );
          $output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
          if(!is_wp_error($children)) {
            $output .= '<ul class="sub-menu">';
            $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'.esc_html__( 'Tüm Yazılar', 'kanews' ).'</a></li>';
            foreach($children as $child) {
              $output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori-ilan')).'">'. $child->name .' ('.$child->count.')</a>';
            }
            $output .= '</ul>';
          }
          $output .= '</li>';
        }
        $output.='</ul></div>';
        echo $output;
        endif;
      ?>
    </div>

  </div>

</div>