<?php
$style = kanews_get_option('related-firma-style') ? kanews_get_option('related-firma-style') : 3; 
$category_ids = '';
if($style != 'disable'):
  $related_count = kanews_get_option('related-firma-count') ? kanews_get_option('related-firma-count') : 3;
  $sortby = kanews_get_option('related-firma-sortby') ? kanews_get_option('related-firma-sortby') : 'commented';
  $categories = get_the_terms( $post->ID, 'kategori' ); if ($categories) {$category_ids = array(); foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;}
  if($sortby == 'commented') {
    $kanews_query = new WP_Query(
      array( 
        'showposts' => $related_count, 
        'post_type' => 'firma',
        'tax_query' => array(
          array(
            'taxonomy' => 'kategori',
            'field'    => 'id',
            'terms'    => $category_ids,
          ),
        ),
        'orderby' => 'comment_count',
        'ignore_sticky_posts'=>1,
        'post__not_in' => array($post->ID),
      )
    );
  } elseif($sortby == 'random') {
    $kanews_query = new WP_Query(
      array( 
        'post_type' => 'firma',
        'tax_query' => array(
          array(
            'taxonomy' => 'kategori',
            'field'    => 'id',
            'terms'    => $category_ids,
          ),
        ),
        'showposts' => $related_count,
        'orderby' => 'rand',
        'ignore_sticky_posts'=>1,
        'post__not_in' => array($post->ID),
      )
    );
  }
  else {
    $kanews_query = new WP_Query(
      array( 
        'post_type' => 'firma',
        'tax_query' => array(
          array(
            'taxonomy' => 'kategori',
            'field'    => 'id',
            'terms'    => $category_ids,
          ),
        ),
        'showposts'    => $related_count,
        'ignore_sticky_posts'=>1,
        'post__not_in' => array($post->ID),
      )
    );
  }

  switch($style) {
    case '1':
      $style = 'comp';
      break;
    case '2':
      $style = 'comp-2';
      break;
    case '3':
      $style = 'comp-3';
      break;
  }

  if ($kanews_query->have_posts()) : ?>
    <div class="kanews-section-box kanews_widget_comp" id="related-posts">
      <?php echo kanews_widget_title(esc_html__( 'Benzer Firmalar', 'kanews' ), 'h4', 'kanews-section-flat-heading'); ?>
      <div class="row">
        <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;
          get_template_part('template-parts/archives/article', $style);
        endwhile; wp_reset_postdata(); ?>
      </div>
    </div>
  <?php endif;
endif;