<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kanews
*/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$pid = get_the_ID();
// kanews_set_post_views($pid);
?>
<div class="col-12 col-lg-9 m-auto kgs2">
  <article id="post-<?php echo $pid; ?>" <?php post_class('kanews-article kanews-section-box kanews-article-4'); ?>>
  
    <?php kanews_entry_header(); ?>
    <?php kanews_post_featured($pid); ?>

    <?php kanews_entry_assets(); ?>
    <?php if( $next_post = get_post_meta($pid, 'select_infinite_next', true) ):  ?>
        <div class="kanews-prev-post-link" hidden><a href="<?php the_permalink($next_post); ?>" rel="prev"></a></div>
      <?php else: ?>
        <div class="kanews-prev-post-link" hidden><?php previous_post_link('%link', '', true); ?></div>
      <?php endif; ?>
		
		<div class="kanews-article-content entry-content">
      <?php 
        // Entry Below
        do_action('kanews_entry_below', $pid);
        // Content
        echo '<div class="entry-content-wrapper" property="articleBody">';
          echo '<div class="entry-content-inner">';
            the_content();
            // Links
            kanews_link_pages();
          echo '</div>';
        echo '</div>';
        // Entry Above
        do_action('kanews_entry_above', $pid);

        if(kanews_get_option('newsletter') == true): get_template_part( 'template-parts/content/components/newsletter'); endif;
			?>
    </div>

  </article>
  <?php get_template_part( 'template-parts/content/components/related', 'posts');?>
  <?php do_action('kanews_entry_comment_above'); ?>
	<?php if ( comments_open() || get_comments_number() ) :
		comments_template();
	endif; ?>
</div>