<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kanews
*/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$pid = get_the_ID();
// kanews_set_post_views($pid);
?>
<div class="col-12 col-lg-9">
  <article id="post-<?php echo $pid; ?>" <?php post_class('kanews-article kanews-section-box kanews-article-1'); ?>>
    <?php if(get_post_meta($pid, 'page_header', true) == 'off'): ?>
      <div class="kanews-article-header pb-0">
        <h1 class="kanews-article-title"><?php the_title(); ?></h1>
      </div>
    <?php endif; ?>
		<div class="kanews-article-content entry-content">
      <?php 
        // Content
        echo '<div class="entry-content-wrapper">';
          echo '<div class="entry-content-inner">';
            kanews_post_featured($pid);
            echo '<div class="entry-content-meta">';
              $default_options = [
                'date' 				=> (kanews_get_option('show-post-date') == false) ? false : true,
                'update-date' => (kanews_get_option('show-post-update-date') == false) ? false : true,
              ];
              $single_options = [
                'date' 			  => get_post_meta( $pid, 'show_post_date', true ),
                'update-date' => get_post_meta( $pid, 'show_post_update_date', true ),
              ];
              if($single_options['date'] == 'on' ) {
                kanews_posted_on();
              } elseif($single_options['date'] != 'off' && $default_options['date'] != false  ) {
                kanews_posted_on();
              }

              if($single_options['update-date'] == 'on' ) {
                kanews_post_updated(true);
              } elseif($single_options['update-date'] != 'off' && $default_options['update-date'] != false  ) {
                kanews_post_updated(true); 
              }
            echo '</div>';
            the_content();
            // Links
            kanews_link_pages();
          echo '</div>';
        echo '</div>';
			?>
    </div>
    
	</article>
	<?php if ( comments_open() || get_comments_number() ) :
		comments_template();
	endif; ?>
</div>
<?php get_sidebar() ;?>