<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly ?>

<footer id="footer" class="site-footer site-footer-2 <?php echo kanews_get_option('footer-skin') == 'dark' ? 'dark-mode' : '' ?> ">

  <div class="container">
    <div class="site-footer-bottom">
      <div class="site-footer-b1">
        <div class="row justify-content-between flex-wrap align-items-center">

          <div class="col-12 col-lg-auto">
            <?php if(kanews_get_option('footer-bottom-text') != ''): ?>
              <div class="site-footer-copyright">
                <?php 
                $footer_vars = array( '%year%', '%site%', '%url%' );
                $footer_val  = array( date('Y') , get_bloginfo('name') , esc_url(home_url( '/' )) );
                echo '<p class="mb-0">'. str_replace( $footer_vars , $footer_val , kanews_get_option( 'footer-bottom-text' )) . '</p>'; ?>
              </div>
            <?php endif; ?>
          </div>

          <?php if( has_nav_menu( 'menu-3' ) ): ?>
            <div class="col">
              <div class="site-footer-menu">
                <?php wp_nav_menu( array(
                  'theme_location' => 'menu-3',
                  'menu_class'     => 'd-flex flex-wrap justify-content-center',
                  'depth'     		 => '1',
                  'container'      => false,
                )); ?>
              </div>
            </div>
          <?php endif; ?>

          <div class="col-12 col-lg-auto text-right">
            <?php kanews_social_links('', 'd-flex justify-content-end'); ?>
          </div>

        </div>
      </div>
    </div>
  </div>

</footer>