<?php 
/**
* Header #2
*
* @since 1.0.0
**/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$height=$height2= '';
if(kanews_get_option('subheader-switch') == true && kanews_get_option('subnavbar-left-bn') == true)
$height = 'head-height-1';
elseif(kanews_get_option('subheader-switch') == true)
$height = 'head-height-2';
elseif(kanews_get_option('subnavbar-left-bn') == true)
$height = 'head-height-3';
$wide = kanews_get_option('header-wide', 'wide');
if($wide == 'normal') {
  $wide = 'container';
} else {
  $wide = 'container-fluid';
}

if( kanews_get_option('subnavbar-left-bn-mobile') == true)
$height2 = 'head2-height-1';

$skin = kanews_get_option('header-skin') ? 'header-skin-'.kanews_get_option('header-skin') : 'header-skin-dark';
?>
<?php kanews_header_top_modules(); ?>
<div class="site-head site-head-2 <?php echo $height; ?> <?php echo $height2; ?>">

  <header id="header" class="site-header">

    <div class="site-header-wrapper  site-navbar-wrapper-fixed">
      <?php if(kanews_get_option('subheader-position') == 'top'): ?>
        <?php get_template_part('template-parts/header/subheader'); ?>
      <?php endif; ?>
      
      <div class="site-header-top <?php echo $skin; ?>">
        <div class="<?php echo $wide; ?>">
          <div class="row site-row justify-content-between align-items-center">

            <div class="col-auto">
              <div class="site-header-top-left d-flex align-items-center gap-1">
                <button aria-label="<?php esc_html_e( 'Menü', 'kanews' ); ?>" class="site-mobil-menu-btn hidden-desktop" data-toggle="site-mobile-menu"><svg class="icon-90deg" width="28" height="28" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="bars"><path fill="currentColor" d="M5,12a1,1,0,0,0-1,1v8a1,1,0,0,0,2,0V13A1,1,0,0,0,5,12ZM10,2A1,1,0,0,0,9,3V21a1,1,0,0,0,2,0V3A1,1,0,0,0,10,2ZM20,16a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V17A1,1,0,0,0,20,16ZM15,8a1,1,0,0,0-1,1V21a1,1,0,0,0,2,0V9A1,1,0,0,0,15,8Z"></path></svg></button>
                
                <?php kanews_logo(); ?>
                <?php kanews_header_big_menu_btn(); ?>
              </div>
            </div>

            <nav id="navbar" class="site-navbar hidden-mobile col">
              <div class="container">
                <div class="navbar-row">
                  <?php if(kanews_get_option('home-button') != false): ?>
                    <div class="col-auto no-gutter">
                      <ul class="site-navbar-nav">
                      <li class="current-menu-item home-btn"><a aria-label="<?php esc_html_e( 'Ana sayfa', 'kanews' ); ?>" href="<?php echo home_url( '/'); ?>"><svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="home"><path fill="currentColor" d="M21.66,10.25l-9-8a1,1,0,0,0-1.32,0l-9,8a1,1,0,0,0-.27,1.11A1,1,0,0,0,3,12H4v9a1,1,0,0,0,1,1H19a1,1,0,0,0,1-1V12h1a1,1,0,0,0,.93-.64A1,1,0,0,0,21.66,10.25ZM13,20H11V17a1,1,0,0,1,2,0Zm5,0H15V17a3,3,0,0,0-6,0v3H6V12H18ZM5.63,10,12,4.34,18.37,10Z"></path></svg></a></li>
                      </ul>
                    </div>
                  <?php endif; ?>
                  <?php kanews_header_nav_menu(); ?>
                  
                </div>
              </div>
            </nav>

            <div class="col-auto">
              <div class="site-header-top-right align-items-center">
                <div class="hidden-mobile"><?php echo kanews_dark_mode_button(); ?></div>
                <?php if(kanews_get_option('kanews-insights') == true && kanews_get_option('kanews-insights-button') == true && kanews_insights_control() == false): ?>
                  <a href="<?php echo kanews_insights_page_url(); ?>" class="header-kanews-insights-btn hidden-mobile">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"><path fill="currentColor" d="M14.72,8.79l-4.29,4.3L8.78,11.44a1,1,0,1,0-1.41,1.41l2.35,2.36a1,1,0,0,0,.71.29,1,1,0,0,0,.7-.29l5-5a1,1,0,0,0,0-1.42A1,1,0,0,0,14.72,8.79ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z"></path></svg>
                                    <?php echo kanews_translate('kanews-insights-button-text', esc_html('Premium\'a Geç', 'kanews')); ?></a>
                <?php endif; ?>
                <?php $header_buttons = kanews_get_option('header-buttons');
                if ($header_buttons && is_array($header_buttons)) {
                  foreach ( $header_buttons as $button ) {
                    $bg_color = !empty($button['color']) ? 'style="background-color: '.$button['color'].'"' : '';
                    $link = !empty($button['url']) ? esc_url($button['url']) : '#';
                    if(!empty($button['title']))
                    echo '<a href="'.$link.'" class="header-btn hidden-mobile" '.$bg_color.'>'.$button['title'].'</a>';
                  }
                } ?>
                <?php if(kanews_get_option('search-button') == true): ?>
                  <?php kanews_header_search_form('style2'); ?>
                <?php endif; ?>
                <?php kanews_header_action_btn(); ?>
                <?php kanews_header_user_btn(); ?>
                <?php echo Kanews\Members\Notifications::get_user_notifications('desktop'); ?>
              </div>
            </div>

          </div>
        </div>
      </div>
      <?php if(kanews_get_option('subheader-position') == 'bottom'): ?>
        <?php get_template_part('template-parts/header/subheader'); ?>
      <?php endif; ?>

      <?php if(kanews_get_option('subnavbar-left-bn') == true): ?>
        <div class="extra-sub bn-bar <?php echo kanews_get_option('subnavbar-left-bn-mobile', false) ? '' :'hidden-mobile'; ?>">
          <div class="site-subheader">
            <div class="container">
              <div class="row site-row align-items-center">
                <div class="col-12">
                  <div class="site-subheader-left">
                  <?php 
                if( kanews_get_option('subnavbar-left-bn-custom', false) )  {
                  $list = kanews_get_option('subnavbar-left-bn-customx', array());
                  if( isset($list[0]) ) {
                    echo  '<ul class="d-flex flex-wrap extra-sub-action">';
                    echo '<li class="home-url"><a href="'.home_url( '/' ).'">'.__('Neler Oluyor', 'kanews').'</a></li>';
                      foreach( $list as $key => $value ) {  
                      
                        if( $value['title'] != ''  &&  $value['url'] != '')
                        echo '<li><a href="'.esc_url($value['url']).'">'.$value['title'].'</a></li>';
                      
                      }
                    echo '</ul>';
                  }
                }  else { 
                  $cats     = (!empty(kanews_get_option('subnavbar-left-bn-cats'))) ? kanews_get_option('subnavbar-left-bn-cats') : 'all';
                  $excluded = (!empty(kanews_get_option('subnavbar-left-bn-post-not-in'))) ? kanews_get_option('subnavbar-left-bn-post-not-in') : '';
                  $count    = (!empty(kanews_get_option('subnavbar-left-bn-count'))) ? kanews_get_option('subnavbar-left-bn-count') : '5';
                  $sortby    = kanews_get_option('subnavbar-left-bn-sortby') == 'recent' ? 'DESC' : 'modified';
                  $title    = kanews_translate('breaking-new-text', esc_html__( 'Son Gelişmeler', 'kanews' ));
                  $query = new WP_Query(
                    array( 
                      'cat'          => $cats,
                      'showposts'    => $count,
                      'orderby'      => $sortby,
                      'post__not_in' => $excluded
                    )
                  );
                  ?>
                  <?php kanews_breaking_news_ticker($title, $query, true, true, $sortby ); 
                }
                ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>
      <?php kanews_header_big_menu(); ?>
    </div>

    

  </header>

</div>