<?php
/**
 * Page Header for Firma Archive
 * 
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit;

// Get featured image or default
$bg_image = get_template_directory_uri() . '/assets/img/static/Footer.jpg';

// Get page title and description
$page_title = get_query_var('page_title') ? get_query_var('page_title') : esc_html__('Firma Rehberi', 'kanews');
$page_description = get_query_var('page_description') ? get_query_var('page_description') : esc_html__('Binlerce firmanın bilgilerine ulaşın, işletmenizi ücretsiz ekleyin.', 'kanews');

// Get links
$add_company_url = kanews_get_option('account-page') ? esc_url(add_query_arg('islem', 'firma-ekle', kanews_account_page_url())) : '#';
$all_companies_url = get_post_type_archive_link('firma');

?>

<div class="kanews-page-header kanews-page-header-cpt">
    <?php if (!empty($bg_image)) : ?>
    <div class="kanews-page-header-bg" style="background-image: url('<?php echo esc_url($bg_image); ?>');"></div>
    <div class="kanews-page-header-overlay"></div>
    <?php endif; ?>
    
    <div class="container">
        <div class="row align-items-center justify-content-center text-center">
            <div class="col-12 col-lg-6">
                <?php if (kanews_get_option('breadcrumb')) : ?>
                <div class="kanews-flat-breadcrumb">
                    <?php kanews_breadcrumb(get_the_ID()); ?>
                </div>
                <?php endif; ?>
                
                <h1 class="kanews-page-title"><?php echo esc_html($page_title); ?></h1>
                
                <?php if (!empty($page_description)) : ?>
                <p class="kanews-page-description"><?php echo esc_html($page_description); ?></p>
                <?php endif; ?>
                
                <div class="kanews-page-header-actions gap-1 d-flex flex-wrap">
                    <?php if (kanews_get_option('account-page')) : ?>
                    <a href="<?php echo esc_url($add_company_url); ?>" class="kanews-btn kanews-btn-sm">
                        <i class="icon-plus"></i> <?php esc_html_e('Firma Ekle', 'kanews'); ?>
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo esc_url($all_companies_url); ?>" class="kanews-btn bg-info kanews-btn-sm">
                        <?php esc_html_e('Tüm Firmalar', 'kanews'); ?>
                    </a>
                </div>
                <div class="kanews-page-header-search">
                    <form method="GET" class="kanews-form-filter" action="<?php echo get_post_type_archive_link('firma'); ?>">
                        <div class="kanews-form2 mb-0 position-relative">
                            <input value="<?php echo isset($_GET['comp_name']) ? esc_attr($_GET['comp_name']) : ''; ?>" type="text" name="comp_name" placeholder="<?php esc_html_e('Firma Adı Ara...', 'kanews'); ?>">
                        </div>
                    </form>
                    <div class="kanews-search-hint"><?php esc_html_e('Firma adı ile arama yaparak aradığınız firmanın bilgilerine ulaşabilirsiniz.', 'kanews'); ?></div>
                </div>
            </div>
            
        </div>
    </div>
</div>

